//
// Multi UV Editor.js
//
//
//  (c) Hiroto Tsubaki
//  http://www.tres-graficos.jp/
//  tg@tres-graficos.jp
//
// 2013-05-03 first release.
//
// Usage: Place this into scripts/Tag folder. restart Cheetah3D, then select this script from Tools -> Script -> Tag Script
//


function buildUI( obj ) {
  
  obj.addParameterSeparator("Multi UV Editor");
  
  obj.addParameterButton("make editor object", "make", "makeEditorObject");
  
  obj.addParameterSeparator("writeback");
  
  obj.addParameterLink("writeback target", true);
  
  obj.addParameterButton("writeback UV", "write", "writebackUV");
  
}

var info = new Array();

function makeEditorObject( tag ) {
  
  var doc = tag.document();
  var root = doc.root();
  
  var target = tag.owner();
  
  if (!target) return;
  
  info.length = 0;
  
  var editor = doc.addObject(POLYGONOBJ);
  var editorCore = editor.core();
  
  editor.setParameter("name", target.getParameter("name"));
  
  root.addChildAtIndex( editor, root.childCount() - 1 );
  
  //
  
  storeInfo( target );
  
  var vertexOffset = 0;
  var polygonOffset = 0;
  var len = info.length;
  for (var i = 0;i < len;i++) {
    var copy = info[i][0];
    var copyCore = copy.core();
    var copyMat = copy.obj2WorldMatrix();
    
    var vertexCount = copyCore.vertexCount();
    var polygonCount = copyCore.polygonCount();
    
    for (var j = 0;j < vertexCount;j++) {
      editorCore.addVertex( false, copyMat.multiply( copyCore.vertex( j ) ) );
    }
    
    for ( var j = 0;j < polygonCount;j++) {
      var polygonSize = copyCore.polygonSize( j );
      var polys = [];
      for (var k = 0;k < polygonSize;k++) {
        polys.push( vertexOffset + copyCore.vertexIndex( j, k ) );
      }
      var polyId = editorCore.addIndexPolygon( polygonSize, polys );
      for (var k = 0;k < polygonSize;k++) {
        editorCore.setUVCoord( polyId, k, copyCore.uvCoord( j, k ) );
        
        editorCore.setEdgeSelection( polyId, k, SEAM, copyCore.edgeSelection( j, k, SEAM ) );
        editorCore.setEdgeSelection( polyId, k, UVPINNED, copyCore.edgeSelection( j, k, UVPINNED ) );
      }
    }
    
    info[i][1] = polygonOffset;
    
    vertexOffset += vertexCount;
    polygonOffset += polygonCount;
  }
  
  tag.setParameter("writeback target", editor);
  
  //print( 'vertexOffset:' + vertexOffset + ', polygonOffset:' + polygonOffset );
  
  editor.update();

}

function writebackUV( tag ) {
  var from = tag.getParameter("writeback target");
  
  if (!from && info.length < 1) return;
  
  var fromCore = from.core();
  
  for (var i = 0;i < info.length;i++) {
    var target = info[i][0];
    var targetCore = target.core();
    
    target.recordGeometryForUndo();
    
    var polygonOffset = info[i][1];
    
    var polygonCount = targetCore.polygonCount();
    for (var j = 0;j < polygonCount;j++) {
      var polygonSize = targetCore.polygonSize( j );
      for (var k = 0;k < polygonSize;k++) {
        targetCore.setUVCoord( j, k, fromCore.uvCoord( polygonOffset + j, k ) );
      }
    }
    
    target.update();
  }
}

function storeInfo( target ) {
  
  var childCount = target.childCount();
  if (childCount > 0) {
    for (var i = 0;i < childCount;i++) {
      var child = target.childAtIndex( i );
      storeInfo( child );
    }
  }
  
  if (target.type() == POLYGONOBJ) {
    info.push( [ target, 0 ] ); // target and polygon offset
  }
}
